<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:javaFile="javaFile:java.io.File"
  exclude-result-prefixes="javaFile">

<xsl:script language="java" implements-prefix="javaFile" 
    src="java:java.io.File"/>

<!-- this file will be much like methodlinks. for the closest public
     methodref in the ancestor list I will have to open the ancestor
     file and check either the read or write attribute of the event
     elements and build a link if I find it.
     -->

<xsl:template name="eventlinks">
  <xsl:variable name="class" select="@name"/>
  <xsl:variable name="context" select="."/>
  <!-- add locally-published events to the list? no, exclude them -->
  <xsl:variable name="eventlist">

    <xsl:copy-of select=".//event[@hasdoc='yes']"/>
    
    <!-- look for links only for the top ancestor
         if it's not documented, other links will be found in recurseancestor -->
    <xsl:for-each select="$context/ancestor[1]">
      <xsl:call-template name="recurseancestorevents">
        <xsl:with-param name="class" select="@name"/>
        <xsl:with-param name="unit" select="@namespace"/>
      </xsl:call-template>
    </xsl:for-each>
  
    <!-- #### links to members of implemented interfaces #### -->
    <xsl:for-each select=".//event[boolean(@declaring_interface)]">
      <xsl:variable name="inteventname">
        <xsl:value-of select="@name"/>
      </xsl:variable>
      <!-- check for nested classes -->
      <!-- look for class/class in the ancestry
           or class/interface or interface/class or
           interface/interface ... -->
      <xsl:choose>
        <xsl:when test="ancestor::class/../../class or ancestor::class/../../interface or ancestor::interface/../../class or ancestor::interface/../../interface">
             </xsl:when>
             <xsl:otherwise>
               <xsl:variable name="declaring_interface">
                 <xsl:value-of select="@declaring_interface"/>
               </xsl:variable>
               <xsl:variable name="linktarget">
                 <xsl:value-of select="//class[@name=$class]/interfaces/implements[contains(@name, $declaring_interface)]/@name"/>
               </xsl:variable>
               <eventlink>
                 <xsl:attribute name="declaring_interface"><xsl:value-of select="$declaring_interface"/></xsl:attribute>
                 <xsl:if test="not(contains($linktarget, 'Borland'))">
                   <xsl:attribute name="docset"><xsl:value-of select="'microsoft'"/></xsl:attribute>
                 </xsl:if>
                 <xsl:if test="contains($linktarget, 'Borland')">
                   <xsl:attribute name="docset"><xsl:value-of select="'borland'"/></xsl:attribute>
                 </xsl:if>
                 <namespace>
                   <xsl:value-of select="substring-before($linktarget, concat('.', $declaring_interface))"/>
          </namespace>
          <interface>
            <xsl:value-of select="$declaring_interface"/>
          </interface>
          <event>
            <xsl:value-of select="$inteventname"/>
          </event>
        </eventlink>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>

</xsl:variable>

<!-- pull the first eventlinks with each name and with no matching event -->

<xsl:for-each select="$eventlist//eventlink">
  <xsl:variable name="eventname" select="event"/>
  <xsl:if test="not($eventlist//event/@name=$eventname) and not (preceding-sibling::eventlink/event=$eventname)">
    <xsl:copy-of select="."/>
  </xsl:if>
</xsl:for-each>



</xsl:template>



<!-- ###################### recurseancestor ##############################3 -->
<!-- This template is a recursive template. It opens the file that the first method of the same name
     in the ancestor list references. If the method is documented in this class, it writes link
     information. If not, it calls itself, with parameters for the *next* ancestor in the ancestor list
     that has a method of the same name.
     -->
<!-- not worrying about nested classes here, in the ancestor hierarchy... -->

<xsl:template name="recurseancestorevents">
  <xsl:param name="class"/>
  <xsl:param name="unit"/>

    <xsl:variable name="classfile" select="concat('compileroutput', '/', $unit, '.xml')"/>
    <!--This next for-each performs operations on each method that we are looking for.-->
    <xsl:variable name="filename" select="javaFile:new($classfile)"/>
    <xsl:choose>
      <xsl:when test="javaFile:exists($filename)">
        <xsl:for-each select="document($classfile)/namespace/class[@name=$class]//event[@hasdoc='yes']">

          <eventlink>
            <xsl:variable name="linknamespace">
              <xsl:value-of select="/namespace/@name"/>
            </xsl:variable>
            <xsl:if test="contains($linknamespace, 'Borland')">
              <xsl:attribute name="docset">borland</xsl:attribute>
            </xsl:if>
            <xsl:if test="not(contains($linknamespace, 'Borland'))">
              <xsl:attribute name="docset">microsoft</xsl:attribute>
            </xsl:if>
            <namespace>
              <xsl:value-of select="$unit"/>
            </namespace>
            <class>
              <xsl:value-of select="$class"/>
            </class>
            <event>
              <xsl:value-of select="@name"/>
            </event>
          </eventlink>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
      </xsl:otherwise>
    </xsl:choose>

    <!-- look at ancestors -->
    <xsl:for-each select="./ancestor[1]">
      <!--Here we call the recursive template with parameters for method, class and unit -->

      <xsl:call-template name="recurseancestorevents">
        <xsl:with-param name="class" select="@name"/>
        <xsl:with-param name="unit" select="@namespace"/>
      </xsl:call-template>
    </xsl:for-each>
    
</xsl:template>
</xsl:stylesheet>
